import java.util.*;

class VettoreOrdinato<E extends Comparable<E>> {
   private Comparable<?> vettore[];
   private int maxDim;  //dimensione massima
   private int curDim;  //dimensione effettiva

public VettoreOrdinato (int maxDim) {
      this.maxDim = maxDim;
	vettore = new Comparable<?>[maxDim];
	curDim = 0;
   }

public VettoreOrdinato () {
	this(10);
 }

public boolean aggiungi (E elemento) {
    if (elemento != null && curDim < maxDim) {
	   vettore[curDim++] = elemento;
       return true;
    } else return false;
 }

public E elimina (int indice) {
    if (indice >= 0 && indice < curDim) {
    	E obj = (E)vettore[indice];
    	vettore[indice] = vettore[--curDim];
	    return obj;
    }
	else return null;
 }

public E elimina () {
	return elimina(curDim-1);
 }

 public E leggi (int indice) {
    if (indice >= 0 && indice < curDim)
	   return (E)vettore[indice];
	else return null;
 }
 
 public int dim () { return curDim; }

//sort(Object[] a, int fromIndex, int toIndex)
//Sorts the specified range of the specified array of objects into ascending order,
//according to the natural ordering of its elements.
 public void ordina () {
	 //NB: toIndex  il numero di items da ordinare
	 Arrays.sort(vettore, 0, curDim);
 }
 
 
 public void stampa () {
	    System.out.print("[ ");
	    for (int i = 0; i < curDim; i++){
	  	  E x = this.leggi(i);
	  	  System.out.print(x + "; ");
	    }
	    System.out.println("]");
	}
 

}

